<?php
/* À ajouter au .htaccess :
# BEGIN Eroan Custom Sitemaps
RewriteEngine On
RewriteRule ^tag-sitemap-(.*)\.xml$ /tag-sitemap.php?tag=$1 [L]
# END Eroan Custom Sitemaps
*/

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// WordPress config
define('WP_USE_THEMES', false);
define('NO_RELATIVE_URLS', true);
require_once( __DIR__ . '/wp-load.php');

// Optimisation SEO
header('Content-Type: application/xml; charset='.get_option('blog_charset'), true);

$tag = empty($_GET['tag']) ? 'default-list' : sanitize_text_field($_GET['tag']);
$transient_name = 'tag-sitemap-' . $tag;
$transient = get_transient( $transient_name );

if ( false === $transient ):

ob_start();

if($_GET['tag']): // Sitemap d'articles

$args = array(
	'post_type'	=> 'post',
	'posts_per_page' => 1000,
	'post_status' => 'publish',
	'order' => 'DESC',
	'orderby' => 'date',
	'no_found_rows' => true,
	'update_post_term_cache' => false,
	'update_post_meta_cache' => false,
	'tag_slug__in' => array($tag)
);

$custom_loop = new WP_Query($args);
if( $custom_loop->have_posts() ):
echo '<?xml version="1.0" encoding="UTF-8"?>'."\n";
?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
<?php while($custom_loop->have_posts()) : $custom_loop->the_post(); ?>
<url>
<loc><?php the_permalink_rss(); ?></loc>
<lastmod><?php echo mysql2date('Y-m-d', get_post_time('Y-m-d H:i:s', false), false); ?></lastmod>
<changefreq>weekly</changefreq>
<priority>1</priority>
</url>
<?php endwhile; ?>
</urlset>

<?php endif; ?>

<?php else: // Sitemap de sitemaps
?>
<sitemapindex xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">
<?php $post_tags = get_tags();
if($post_tags): ?>
<?php foreach($post_tags as $post_tag): ?>
<sitemap>
<loc><?php echo get_site_url(); ?>/tag-sitemap.php?tag=<?php echo $post_tag->slug; ?></loc>
<?php

$args = array(
	'post_type'	=> 'post',
	'posts_per_page' => 1,
	'post_status' => 'publish',
	'order' => 'DESC',
	'orderby' => 'date',
	'no_found_rows' => true,
	'update_post_term_cache' => false,
	'update_post_meta_cache' => false,
	'tag_slug__in' => array($post_tag->slug)
);

$custom_loop = new WP_Query($args);
if( $custom_loop->have_posts() ):
while($custom_loop->have_posts()) : $custom_loop->the_post(); ?>
<lastmod><?php echo mysql2date('Y-m-d', get_post_time('Y-m-d H:i:s', false), false); ?></lastmod>
<?php endwhile; ?>
<?php endif; ?>
</sitemap>
<?php endforeach; ?>
<?php endif; ?>
</sitemapindex>
<?php endif; ?>

<?php $rendu = ob_get_clean(); echo $rendu; ?>
<?php set_transient( $transient_name, $rendu, 10 * MINUTE_IN_SECONDS ); ?>

<?php else: ?>
<?php echo $transient; ?>
<?php endif; ?>